#ifndef __MT_TXMB_VIEWER_H__
#define __MT_TXMB_VIEWER_H__

#include "MTGrafPortWindow.h"
#include "MTTXMPViewer.h"
#include "MTViewer.h"

struct MTTXMBEntry
{
	MTTXMPHandler	handler;
	UInt32			id;
};

class MTTXMBViewer : public MTGrafPortWindow, public MTViewer
{
	public:
				MTTXMBViewer();
				~MTTXMBViewer();
		
		void	ParseData(UInt8 * buf, UInt32 bufSize);
		
		void	GetWindowName(StringPtr theString);
		
		void	RecieveMessage(UInt32 messageType, UInt32 messageData);
		UInt8	SupportsMessage(UInt32 messageType, UInt32 messageData);
	
	protected:
		void	GetPortSize(UInt32 * inWidth, UInt32 * inHeight)	{ *inWidth = totalWidth; *inHeight = totalHeight; }
		UInt32	GetPortDepth(void)									{ return depth; }
		void	DrawToPort(GWorldPtr theWorld);
	
	private:
		void	SpawnInfoWindow(void);
		
		static MTInfoWindowDataTemplate	kTXMBTemplate;
		
		UInt32						id, version, unknown1, unknown2, width, height;
		
		UInt32						totalWidth, totalHeight, depth;
		std::vector <MTTXMBEntry>	entries;
};

#endif /* __MT_TXMB_VIEWER_H__ */